##############################################################################
#                                                                            #
# Schrittmotor-Steuerung | stepper.pl 0.91                                   #
#                                                                            #
# CGI-Perlscript fr Windows-Webserver                                       #
#                                                                            #
# Steuert Schrittmotorkarte von Pollin Electronic.                           #
#                                                                            #
# Written 2006-2007 Harald Gabler                                            #
# E-Mail: harald.gabler@netcamera.org                                        #
# Internet: http://www.netcamera.org                                         #
#                                                                            #
##############################################################################

# URL des Perlscripts
my $script_url = "http://meinpc.dyndns.org:80/stepper/stepper.cgi";

# URL des HTML-Verzeichnis (ohne Schraegstrich am Ende)
my $noncgi_dir = ".";

# Portadresse (LTP1 => 0x378 / LTP2 => 0x278)
my $port = 0x378;

##############################################################################

use strict;

use CGI;
my $cgi = new CGI;
use CGI::Carp qw(fatalsToBrowser);

my $speed  = int(0);
my $steps  = int(0);
my $dir    = int(0);
my $switch = 0;
my $statusbar = "&nbsp;";
my @status;
my ($GetPortVal, $SetPortVal);

if($cgi->param()) { checkForm(); }

open(LOCK,"<lock.dat");
   if(flock LOCK, 2 | 4) {   # Sperre aktivieren
      use Time::HiRes;
      use Win32::API;                                                         # load API module to interface DLL's 
      $GetPortVal = new Win32::API("inpout32", "Inp32", ['I'], 'I');       # import Inp32 from DLL 
      $SetPortVal = new Win32::API("inpout32", "Out32", ['I','I'], 'I');   # import Out32 from DLL

      $port = $port + 2;
      readPort();
      $status[5] = "0";   # Bidirektional aus
      writePort();
      $port = $port - 2;

      set0();

      if($dir > 0) { turnRight(); }
      else         { turnLeft(); }

      set0();
   }
   else {
      $statusbar = "Die Steuerung wird im Moment benutzt.";
   }
close(LOCK);   # Sperre lsen

printHeader();
printSteps();
printDirection();
printStart();
printStatusBar();
printFooter();

##############################################################################

# Port auslesen und Bitstatus setzen
sub readPort {
   my $wert = $GetPortVal->Call($port) & 255;
   for(my $i = 7; $i >= 0; $i--) {
      $status[$i] = int($wert / (2 ** ($i)));
      $wert = $wert % (2 ** ($i));
   }
}

# Bitstatus auf Port schreiben
sub writePort {
   my $wert = 0;
   for(my $i = 0; $i <= 7; $i++) {
      $wert += $status[$i] * (2 ** ($i));
   }
   my $return = $SetPortVal->Call($port,$wert);
}

sub set0 {
   my $wert = 0;
   my $return = $SetPortVal->Call($port,$wert);
}

sub setA {
   my $wert = 1;
   my $return = $SetPortVal->Call($port,$wert);
}

sub setB {
   my $wert = 2;
   my $return = $SetPortVal->Call($port,$wert);
}

sub setC {
   my $wert = 4;
   my $return = $SetPortVal->Call($port,$wert);
}

sub setD {
   my $wert = 8;
   my $return = $SetPortVal->Call($port,$wert);
}

sub turnLeft {
   for(my $i = 0; $i < $steps; $i) {
      if($i >= $steps) { last; }
      checkSwitch();
      if($switch > 0) { last; }
      setA();
      $i++;
      Time::HiRes::sleep($speed / 1000);
      if($i >= $steps) { last; }
      checkSwitch();
      if($switch > 0) { last; }
      setC();
      $i++;
      Time::HiRes::sleep($speed / 1000);
      if($i >= $steps) { last; }
      checkSwitch();
      if($switch > 0) { last; }
      setB();
      $i++;
      Time::HiRes::sleep($speed / 1000);
      if($i >= $steps) { last; }
      checkSwitch();
      if($switch > 0) { last; }
      setD();
      $i++;
      Time::HiRes::sleep($speed / 1000);
   }
}

sub turnRight {
   for(my $i = 0; $i < $steps; $i) {
      if($i >= $steps) { last; }
      checkSwitch();
      if($switch > 0) { last; }
      setC();
      $i++;
      Time::HiRes::sleep($speed / 1000);
      if($i >= $steps) { last; }
      checkSwitch();
      if($switch > 0) { last; }
      setA();
      $i++;
      Time::HiRes::sleep($speed / 1000);
      if($i >= $steps) { last; }
      checkSwitch();
      if($switch > 0) { last; }
      setD();
      $i++;
      Time::HiRes::sleep($speed / 1000);
      if($i >= $steps) { last; }
      checkSwitch();
      if($switch > 0) { last; }
      setB();
      $i++;
      Time::HiRes::sleep($speed / 1000);
   }
}

# Endschalter auswerten
sub checkSwitch {
   $port = $port + 1;
   readPort();
   if($status[6] == 0 && $dir < 1) {   # Linker Schalter an Pin 10 kurzgeschlossen
      $switch = 1;
      $statusbar = "Linker Endschalter erreicht.";
   }
   if($status[7] == 1 && $dir > 0) {   # Rechter Schalter an Pin 11 kurzgeschlossen
      $switch = 1;
      $statusbar = "Rechter Endschalter erreicht.";
   }
   $port = $port - 1;
}

# Formulardaten auswerten und neuen Bitstatus setzen
sub checkForm {
   $speed = int($cgi->param("Speed"));
   if($speed < 0) {$speed = "0";}
   $steps = int($cgi->param("Steps"));
   if($steps < 0) {$steps = "0";}
   $dir   = int($cgi->param("Direction"));
}

# Ausgabe im Browser
sub printHeader {
#  print "Content-type: text/html\n\n";
   print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n";
   print "<html>\n";
   print "<head>\n";
   print "<meta http-equiv=\"content-type\" content=\"text/html; charset=ISO-8859-1\">\n";
   print "<link rel=\"stylesheet\" type=\"text/css\" href=\"$noncgi_dir/format.css\">\n";
   print "<title>Schrittmotor-Steuerung</title>\n";
   print "</head>\n";
   print "<body>\n";
   print "<p><big>Schrittmotor-Steuerung</big></p>\n";
   print "<form name=\"Stepper\" action=\"$script_url\" method=\"post\">\n";
}

sub printFooter {
   print "</form>\n";
   print "<p><small>Schrittmotor-Steuerung 0.91<br>&copy\; 2006 Harald Gabler - <a href=\"http://www.netcamera.org\">netcamera.org</a></small></p>\n";
   print "</body>\n";
   print "</html>\n";
}

sub printSteps {
   print "<fieldset><legend>Schritte und Geschwindigkeit</legend>\n";
   print "<table><tr>\n";
   print "<td>\n";
   print "<p>\n";
   print "Motorschritte: <input type=\"text\" name=\"Steps\" size=\"6\" maxlength=\"6\" value=\"$steps\"><br>\n";
   print "</p>\n";
   print "</td>\n";
   print "<td>\n";
   print "<p>\n";
   print "Geschwindigkeit: <input type=\"text\" name=\"Speed\" size=\"6\" maxlength=\"6\" value=\"$speed\">\n";
   print "</p>\n";
   print "</td>\n";
   print "</tr></table>\n";
   print "</fieldset>\n";
   print "<p></p>\n";
}

sub printDirection {
   print "<fieldset><legend>Drehrichtung</legend>\n";
   print "<table><tr>\n";
   print "<td>\n";
   print "<p>\n";
   if($dir > 0) { print "<input type=\"radio\" name=\"Direction\" size=\"4\" maxlength=\"4\" value=\"0\"> Links gegen Uhrzeigersinn\n"; }
   else { print "<input type=\"radio\" name=\"Direction\" size=\"4\" maxlength=\"4\" value=\"0\" checked> Links gegen Uhrzeigersinn\n"; }
   print "</p>\n";
   print "</td>\n";
   print "<td>\n";
   print "<p>\n";
   if($dir > 0) { print "<input type=\"radio\" name=\"Direction\" size=\"4\" maxlength=\"4\" value=\"1\" checked> Rechts im Uhrzeigersinn\n"; }
   else { print "<input type=\"radio\" name=\"Direction\" size=\"4\" maxlength=\"4\" value=\"1\"> Rechts im Uhrzeigersinn\n"; }
   print "</p>\n";
   print "</td>\n";
   print "</tr></table>\n";
   print "</fieldset>\n";
   print "<p></p>\n";
}

sub printStart {
   print "<fieldset><legend>Motor</legend>\n";
   print "<table><tr>\n";
   print "<td>\n";
   print "<input type=\"submit\" name=\"Start\" value=\"Motor starten\">\n";
   print "</td>\n";
   print "</tr></table>\n";
   print "</fieldset>\n";
   print "<p></p>\n";
}

sub printStatusBar {
   print "<fieldset><legend>Statuszeile</legend>\n";
   print "<table><tr>\n";
   print "<td>\n";
   print "<p>\n";
   print "$statusbar\n";
   print "</p>\n";
   print "</td>\n";
   print "</tr></table>\n";
   print "</fieldset>\n";
}
