##############################################################################
#                                                                            #
# Relais-Steuerung | relais.pl 1.01                                          #
#                                                                            #
# CGI-Perlscript fr Windows-Webserver                                       #
#                                                                            #
# Steuert Relaiskarte an der parallelen Schnittstelle.                       #
#                                                                            #
# Written 2005-2006 Harald Gabler                                            #
# E-Mail: harald.gabler@netcamera.org                                        #
# Internet: http://www.netcamera.org                                         #
#                                                                            #
##############################################################################

# URL des Perlscripts
my $script_url = "http://meinpc.dyndns.org:80/cgi-bin/relais/relais.pl";

# URL des HTML-Verzeichnis (ohne Schraegstrich am Ende)
my $noncgi_dir = ".";

# Portadresse (LTP1 => 0x378 / LTP2 => 0x278)
my $port = 0x378;

# Schalter/Tasten-Modus (0 = Schaltermodus, 1 = Tastenmodus)
my $mode = "0";

# Automatische Aktualisierung (0 = aus, 1 oder groesser = Refresh-Intervall in Sekunden)
my $refresh = "0";

# Name der Seite
my $page_name = "Relais-Steuerung";

# Name des Statusfeldes
my $status_name = "Status der Relais";

# Statusfeld anzeigen (0 = Anzeige aus, 1 = Anzeige ein)
my $status_view = "1";

# Namen der Schalter
my @switch_name = ("Schalter 1","Schalter 2","Schalter 3","Schalter 4","Schalter 5","Schalter 6","Schalter 7","Schalter 8");

# Schalter anzeigen (0 = Anzeige aus, 1 = Anzeige ein)
my @switch_view = ("1","1","1","1","1","1","1","1");

# Name des Feldes zum Schalten aller Relais
my $all_name = "Alle Relais";

# Feld "Alle Relais" anzeigen (0 = Anzeige aus, 1 = Anzeige ein)
my $all_view = "1";

# Name des Eingangsfeldes
my $input_name = "Status der Eingnge";

# Eingangsfeld anzeigen (0 = Anzeige aus, 1 = Anzeige ein)
my $input_view = "1";

# Namen der LEDs (n/a = ohne Funktion nicht aendern)
my @led_name = ("n/a","n/a","n/a","Pin 15","Pin 13","Pin 12","Pin 10","Pin 11");

# LEDs anzeigen (n/a = ohne Funktion nicht aendern, 0 = Anzeige aus, 1 = Anzeige ein)
my @led_view = ("n/a","n/a","n/a","1","1","1","1","1");

##############################################################################

use strict;

use CGI;
my $cgi = new CGI;
use CGI::Carp qw(fatalsToBrowser);

use Win32::API;                                                         # load API module to interface DLL's 
my $GetPortVal = new Win32::API("inpout32", "Inp32", ['I'], 'I');       # import Inp32 from DLL 
my $SetPortVal = new Win32::API("inpout32", "Out32", ['I','I'], 'I');   # import Out32 from DLL

my @status;

$port = $port + 2;
readPort();
$status[5] = "0";   # Bidirektional aus
writePort();
$port = $port - 2;

if($mode > 0) { setLow(); }
readPort();

if($cgi->param()) {
   checkForm();
   writePort();
   if($mode > 0) {
      sleep($mode);
      setLow();
      readPort();
   }
}

printHeader();
if ($status_view > 0) { printStatus(); }
if ($all_view > 0) { printAll(); }
if ($input_view > 0) {
   $port = $port + 1;
   readPort();
   printInput();
}
printRefresh();
printFooter();

##############################################################################

# Port auslesen und Bitstatus setzen
sub readPort {
   my $wert = $GetPortVal->Call($port) & 255;
   for(my $i = 7; $i >= 0; $i--) {
      $status[$i] = int($wert / (2 ** ($i)));
      $wert = $wert % (2 ** ($i));
   }
}

# Formulardaten auswerten und neuen Bitstatus setzen
sub checkForm {
   my $a = $cgi->param("A");
   if($a eq "Einschalten") {
      for(my $i = 0; $i <= 7; $i++) {
         $status[$i] = 1;
      }
   }
   elsif($a eq "Ausschalten") {
      for(my $i = 0; $i <= 7; $i++) {
         $status[$i] = 0;
      }
   }
   for(my $i = 0; $i <= 7; $i++) {
      my $s = $cgi->param("S$i");
      if($s ne "") {
         my $r = $cgi->param("R$i");
         if($r == 0) {
            $status[$i] = 1;
         }
         elsif($r == 1) {
            $status[$i] = 0;
         }
      }
   }
}

# Bitstatus auf Port schreiben
sub writePort {
   my $wert = 0;
   for(my $i = 0; $i <= 7; $i++) {
      $wert += $status[$i] * (2 ** ($i));
   }
   my $return = $SetPortVal->Call($port,$wert);
}

# Bytestatus 0 auf Port schreiben
sub setLow {
   my $wert = 0;
   my $return = $SetPortVal->Call($port,$wert);
}

# Ausgabe im Browser
sub printHeader {
   print "Content-type: text/html\n\n";
   print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n";
   print "<html>\n";
   print "<head>\n";
   if($refresh > 0) { print "<meta http-equiv=\"refresh\" content=\"$refresh; URL=$script_url\">\n"; }
   print "<meta http-equiv=\"content-type\" content=\"text/html; charset=ISO-8859-1\">\n";
   print "<link rel=\"stylesheet\" type=\"text/css\" href=\"$noncgi_dir/format.css\">\n";
   print "<title>$page_name</title>\n";
   print "</head>\n";
   print "<body>\n";
   print "<p><big>$page_name</big></p>\n";
   print "<form name=\"Relais\" action=\"$script_url\" method=\"post\">\n";
}

sub printFooter {
   print "</form>\n";
   print "<p><small>Relais-Steuerung 1.01<br>&copy\; 2005-2006 Harald Gabler - <a href=\"http://www.netcamera.org\">netcamera.org</a></small></p>\n";
   print "</body>\n";
   print "</html>\n";
}

sub printStatus {
   print "<fieldset><legend>$status_name</legend>\n";
   print "<table><tr>\n";
   for(my $i = 0; $i <= 7; $i++) {
      if($switch_view[$i] > 0) {
         if($status[$i] == 1) {
            print "<td>\n";
            if($mode == 0) { print "<img src=\"$noncgi_dir/led_ein.gif\" alt=\"\"><br>\n"; }
            print "<input type=\"hidden\" name=\"R$i\" value=\"1\">\n";
            if($switch_name[$i] eq "") {
               $switch_name[$i] = "Schalter " . ($i + 1);
            }
            print "<input type=\"submit\" name=\"S$i\" value=\"$switch_name[$i]\">\n";
            print "</td>\n";
         }
         elsif($status[$i] == 0) {
            print "<td>\n";
            if($mode == 0) { print "<img src=\"$noncgi_dir/led_aus.gif\" alt=\"\"><br>\n"; }
            print "<input type=\"hidden\" name=\"R$i\" value=\"0\">\n";
            if($switch_name[$i] eq "") {
               $switch_name[$i] = "Schalter " . ($i + 1);
            }
            print "<input type=\"submit\" name=\"S$i\" value=\"$switch_name[$i]\">\n";
            print "</td>\n";
         }
      }
   }
   print "</tr></table>\n";
   print "</fieldset>\n";
   print "<p></p>\n";
}

sub printAll {
   print "<fieldset><legend>$all_name</legend>\n";
   print "<table><tr>\n";
   print "<td>\n";
   print "<input type=\"submit\" name=\"A\" value=\"Einschalten\">\n";
   print "</td>\n";
   if($mode == 0) {
      print "<td>\n";
      print "<input type=\"submit\" name=\"A\" value=\"Ausschalten\">\n";
      print "</td>\n";
   }
   print "</tr></table>\n";
   print "</fieldset>\n";
   print "<p></p>\n";
}

sub printInput {
   print "<fieldset><legend>$input_name</legend>\n";
   print "<table><tr>\n";
   for(my $i = 3; $i <= 7; $i++) {
      if($led_view[$i] > 0) {
         if($status[$i] == 1) {
            print "<td>\n";
            if($i < 7) { print "<img src=\"$noncgi_dir/led_aus.gif\" alt=\"\"><br>\n"; }
            else { print "<img src=\"$noncgi_dir/led_ein.gif\" alt=\"\"><br>\n"; }
            print "<small>$led_name[$i]</small>\n";
            print "</td>\n";
         }
         elsif($status[$i] == 0) {
            print "<td>\n";
            if($i < 7) { print "<img src=\"$noncgi_dir/led_ein.gif\" alt=\"\"><br>\n"; }
            else { print "<img src=\"$noncgi_dir/led_aus.gif\" alt=\"\"><br>\n"; }
            print "<small>$led_name[$i]</small>\n";
            print "</td>\n";
         }
      }
   }
   print "</tr></table>\n";
   print "</fieldset>\n";
   print "<p></p>\n";
}

sub printRefresh {
   print "<fieldset><legend>Anzeige</legend>\n";
   print "<table><tr>\n";
   print "<td>\n";
   print "<input name=\"refresh\" type=\"button\" value=\"Anzeige aktualisieren\" onClick=\"javascript:location.href=\'$script_url\';\">\n";
   print "</td>\n";
   print "</tr></table>\n";
   print "</fieldset>\n";
}
