##############################################################################
#                                                                            #
# init.pl                                                                    #
#                                                                            #
# Perlscript fr Windows-Console                                             #
#                                                                            #
# Setzt die Datenkanaele der parallelen Schnittstelle je nach Konfiguration  #
# auf High- oder Low-Pegel.                                                  #
#                                                                            #
# Written 2006 Harald Gabler                                                 #
# E-Mail: harald.gabler@netcamera.org                                        #
# Internet: http://www.netcamera.org                                         #
#                                                                            #
##############################################################################

# Portadresse (LTP1 => 0x378 / LTP2 => 0x278)
my $port = 0x378;

# Datenkanaele 1-8 setzen (0 = low/aus, 1 = high/ein, -1 = unveraendert)
my @channel = ("0","0","0","0","0","0","0","0");

##############################################################################

use strict;

use Win32::API;                                                         # load API module to interface DLL's 
my $GetPortVal = new Win32::API("inpout32", "Inp32", ['I'], 'I');       # import Inp32 from DLL 
my $SetPortVal = new Win32::API("inpout32", "Out32", ['I','I'], 'I');   # import Out32 from DLL

my @status;

$port = $port + 2;
readPort();
$status[5] = "0";   # Bidirektional aus
writePort();
$port = $port - 2;

readPort();
for(my $i = 0; $i <= 7; $i++) {
   if($channel[$i] > 0) { $status[$i] = 1; }
   elsif($channel[$i] == 0) { $status[$i] = 0; }
}
writePort();

print "\nKanaele geschaltet\n";

##############################################################################

#Port auslesen und Bitstatus setzen
sub readPort {
   my $wert = $GetPortVal->Call($port) & 255;
   for(my $i = 7; $i >= 0; $i--) {
      $status[$i] = int($wert / (2 ** ($i)));
      $wert = $wert % (2 ** ($i));
   }
}

#Bitstatus auf Port schreiben
sub writePort {
   my $wert = 0;
   for(my $i = 0; $i <= 7; $i++) {
      $wert += $status[$i] * (2 ** ($i));
   }
   my $return = $SetPortVal->Call($port,$wert);
}
