#!/usr/bin/perl

##############################################################################
#                                                                            #
# CamHistory | view.pl 1.11                                                  #
#                                                                            #
# CGI-Perlscript fr Webserver                                               #
#                                                                            #
# Zeigt Bilder aus dem Archiv in Listenform an.                              #
#                                                                            #
# Written 2002-2019 Harald Gabler                                            #
# E-Mail: harald.gabler@netcamera.org                                        #
# Internet: http://www.netcamera.org                                         #
#                                                                            #
##############################################################################

use CGI::Carp qw(fatalsToBrowser);

require "./camhist.cfg";

opendir(DIR, $archive_path) || die "$archive_path: $!";
@dir_files = readdir(DIR);
closedir(DIR);

@files = grep(/\.jpg/,@dir_files);
@files = sort(@files);
@files = reverse(@files);

print "Content-type: text/html\n\n";

print "<html>\n";
print "<head>\n";
print "<title>Archivbilder ansehen</title>\n";
print "<script language=\"JavaScript\">\n";
print "<!--\n";
print "function changePic(URL) {\n";
print "document.image1.src = URL;\n";
print "}\n";
print "//-->\n";
print "</script>\n";
print "<style type=\"text/css\">\n";
print "<!--\n";
print "select\n";
print "{ font-size:13px; font-family:Arial,Helvetica,sans-serif; }\n";
print "//-->\n";
print "</style>\n";
print "</head>\n";
print "<body bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#000066\" vlink=\"#000066\" alink=\"#000066\">\n";
print "<center>\n";
print "<img src=\"$archive_url/$files[0]\" name=\"image1\" width=\"$picX\">\n";
print "<p>\n";
print "<form action=\"\">\n";
print "<select name=\"list1\" size=\"5\" onChange=\"changePic(this.value)\">\n";
$selected = 0;
foreach(@files) {
   $filelength = length($_);
   for($i=0; $i<$filelength; $i++) {
      $character[$i] = substr($_,$i,1);
   }
   $filename = "&nbsp;Datum: $character[0]$character[1]$character[2]$character[3]-$character[4]$character[5]-$character[6]$character[7]&nbsp;&nbsp;Uhrzeit: $character[9]$character[10]:$character[11]$character[12]&nbsp;";
   if($selected == 0) {
      print "<option value=\"$archive_url/$_\" selected>$filename</option>\n";
      $selected = 1;
   }
   else {
      print "<option value=\"$archive_url/$_\">$filename</option>\n";
   }
}
print "</select>\n";
print "</form>\n";
print "<p>\n";
print "<form action=\"\">\n";
print "<input type=\"button\" value=\"Fenster schlie&szlig;en\" onClick=\"self.close()\">\n";
print "</form>\n";
print "</center>\n";
print "</body>\n";
print "</html>\n";
