#!/usr/bin/perl

##############################################################################
#                                                                            #
# CamHistory | save.pl 1.11                                                  #
#                                                                            #
# CGI-Perlscript fr Webserver                                               #
#                                                                            #
# Start durch Verweis auf Webseite. Speichert Kamerabilder in ein            #
# Archivverzeichnis.                                                         #
#                                                                            #
# Written 2002-2019 Harald Gabler                                            #
# E-Mail: harald.gabler@netcamera.org                                        #
# Internet: http://www.netcamera.org                                         #
#                                                                            #
##############################################################################

use CGI::Carp qw(fatalsToBrowser);

require "./camhist.cfg";

use LWP::Simple;

opendir(DIR, $archive_path) || die "$archive_path: $!";
@dir_files = readdir(DIR);
closedir(DIR);

@files = grep(/\.jpg/,@dir_files);
@files = sort(@files);
@files = reverse(@files);

$file_count = @files;

if($max_pic > 0) {
   while($file_count >= $max_pic) {
      unlink("$archive_path\/$files[-1]");
      pop(@files);
      $file_count = @files;
   }
}

$content = get("$webcam_url");

if(defined $content) {
   ($content_type,$document_length,$modified_time,$expires,$server) = head("$webcam_url");
   if($modified_time == "") {
      ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
   }
   else {
      ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($modified_time);
   }

   $year = $year + 1900;
   $mon = $mon + 1;
   if ($mon < 10)  { $mon  = "0$mon"; }
   if ($mday < 10) { $mday = "0$mday"; }
   if ($hour < 10) { $hour = "0$hour"; }
   if ($min < 10) { $min = "0$min"; }
   if ($sec < 10) { $sec = "0$sec"; }

   $archive_file = "$year$mon$mday\_$hour$min$sec\.jpg";

   open(PIC,">$archive_path\/$archive_file") || die "Fehler beim Oeffnen von $archive_file: $!\n";
      binmode(PIC);
      print PIC $content;
   close(PIC);
}
else {
   $archive_file = "offline.gif";
}

# Archivbild anzeigen
print "content-type: text/html\n\n";

print "<html>\n";
print "<head>\n";
print "<title>Kamerabild archiviert</title>\n";
print "</head>\n";
print "<body bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#000066\" vlink=\"#000066\" alink=\"#000066\">\n";
print "<font face=\"Arial, Helvetica\" size=\"-1\">\n";
print "<center>\n";
# print "<span style=\"font-family:Arial,Helvetica,sans-serif;font-size:13px\">$content_type, $document_length, $modified_time, $expires, $server</span><p>\n";
print "<span style=\"font-family:Arial,Helvetica,sans-serif;font-size:13px\">Dieses Kamerabild wurde dem Archiv hinzugef&uuml;gt.</span>\n";
print "<p>\n";
print "<img src=\"$archive_url/$archive_file\" width=\"$picX\">\n";
print "<p>\n";
print "<form action=\"\">\n";
print "<input type=\"button\" value=\"Fenster schlie&szlig;en\" onClick=\"self.close()\">\n";
print "</form>\n";
print "</center>\n";
print "</font>\n";
print "</body>\n";
print "</html>\n";

# Ende
exit;
