#!/usr/bin/perl

##############################################################################
#                                                                            #
# CamHistory | c_save.pl 1.11                                                #
#                                                                            #
# Perlscript fr Console                                                     #
#                                                                            #
# Start durch Cronjob. Speichert Kamerabilder in ein Archivverzeichnis.      #
#                                                                            #
# Written 2002-2019 Harald Gabler                                            #
# E-Mail: harald.gabler@netcamera.org                                        #
# Internet: http://www.netcamera.org                                         #
#                                                                            #
##############################################################################

# Serverpfad zur Konfigurationsdatei
require "/home/user/www.domain.de/cgi-bin/camhist/camhist.cfg";

##############################################################################

use LWP::Simple;

opendir(DIR, $archive_path) || die "$archive_path: $!";
@dir_files = readdir(DIR);
closedir(DIR);

@files = grep(/\.jpg/,@dir_files);
@files = sort(@files);
@files = reverse(@files);

$file_count = @files;

if($max_pic > 0) {
   while($file_count >= $max_pic) {
      unlink("$archive_path\/$files[-1]");
      pop(@files);
      $file_count = @files;
   }
}

$content = get("$webcam_url");

if(defined $content) {
   ($content_type,$document_length,$modified_time,$expires,$server) = head("$webcam_url");
   if($modified_time == "") {
      ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
   }
   else {
      ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($modified_time);
   }

   $year = $year + 1900;
   $mon = $mon + 1;
   if ($mon < 10)  { $mon  = "0$mon"; }
   if ($mday < 10) { $mday = "0$mday"; }
   if ($hour < 10) { $hour = "0$hour"; }
   if ($min < 10) { $min = "0$min"; }
   if ($sec < 10) { $sec = "0$sec"; }

   $archive_file = "$year$mon$mday\_$hour$min$sec\.jpg";

   open(PIC,">$archive_path\/$archive_file") || die "Fehler beim Oeffnen von $archive_file: $!\n";
      binmode(PIC);
      print PIC $content;
   close(PIC);
}
